/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.ui.views;

import com.aptana.scripting.model.BundleElement;
import com.aptana.scripting.model.MenuElement;
import com.aptana.scripting.ui.ScriptingUIPlugin;
import com.aptana.scripting.ui.views.BaseNode;
import com.aptana.scripting.ui.views.IPropertyInformation;
import com.aptana.scripting.ui.views.MenuNode;
import com.aptana.scripting.ui.views.Messages;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MenusNode
extends BaseNode<Property> {
    private static final Image MENUS_ICON = ScriptingUIPlugin.getImage("icons/folder.png");
    private MenuNode[] menus;

    MenusNode(BundleElement bundle) {
        this(bundle.getMenus());
    }

    MenusNode(List<MenuElement> elements) {
        if (elements != null) {
            Collections.sort(elements);
            this.menus = new MenuNode[elements.size()];
            int i = 0;
            while (i < elements.size()) {
                this.menus[i] = new MenuNode(elements.get(i));
                ++i;
            }
        } else {
            this.menus = new MenuNode[0];
        }
    }

    @Override
    public Object[] getChildren() {
        return this.menus;
    }

    @Override
    public Image getImage() {
        return MENUS_ICON;
    }

    @Override
    protected Set<Property> getPropertyInfoSet() {
        return EnumSet.allOf(Property.class);
    }

    @Override
    public String getLabel() {
        return Messages.MenusNode_Menus_Node;
    }

    @Override
    public boolean hasChildren() {
        return this.menus.length > 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Property implements IPropertyInformation<MenusNode>
    {
        COUNT(Messages.MenusNode_Menus_Count){

            public Object getPropertyValue(MenusNode node) {
                return node.menus.length;
            }
        };

        private String header;

        private Property(String header) {
            this.header = header;
        }

        @Override
        public String getHeader() {
            return this.header;
        }

        @Override
        public Object getPropertyValue(MenusNode node) {
            return null;
        }
    }
}

